/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.model.rendering.texture;

import java.lang.reflect.Type;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import org.figuramc.figura.mixin.render.layers.elytra.ElytraLayerAccessor;
import org.figuramc.figura.model.TextureCustomization;
import org.figuramc.figura.model.rendering.texture.FiguraTexture;
import org.jetbrains.annotations.Nullable;

public class FiguraTextureSet {
    public final String name;
    public final FiguraTexture[] textures = new FiguraTexture[4];

    public FiguraTextureSet(String name, FiguraTexture mainData, FiguraTexture emissiveData, FiguraTexture specularData, FiguraTexture normalData) {
        this.name = name;
        this.textures[0] = mainData;
        this.textures[1] = emissiveData;
        this.textures[2] = specularData;
        this.textures[3] = normalData;
    }

    public void clean() {
        for (FiguraTexture texture : this.textures) {
            if (texture == null) continue;
            texture.close();
        }
    }

    public void uploadIfNeeded() {
        for (FiguraTexture texture : this.textures) {
            if (texture == null) continue;
            texture.uploadIfDirty();
        }
    }

    public int getWidth() {
        for (FiguraTexture texture : this.textures) {
            if (texture == null) continue;
            return texture.getWidth();
        }
        return -1;
    }

    public int getHeight() {
        for (FiguraTexture texture : this.textures) {
            if (texture == null) continue;
            return texture.getHeight();
        }
        return -1;
    }

    public ResourceLocation getOverrideTexture(UUID owner, TextureCustomization pair) {
        OverrideType type;
        if (pair == null || (type = pair.getOverrideType()) == null) {
            return null;
        }
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1, 2 -> {
                ResourceLocation var4_9;
                ClientPacketListener connection = Minecraft.getInstance().getConnection();
                if (connection == null) {
                    Object var4_7 = null;
                    yield var4_7;
                }
                PlayerInfo info = connection.getPlayerInfo(owner);
                if (info == null) {
                    Object var4_8 = null;
                    yield var4_8;
                }
                ResourceLocation v1 = switch (type.ordinal()) {
                    case 1 -> info.getSkin().capeTexture();
                    case 2 -> {
                        if (info.getSkin().elytraTexture() == null) {
                            yield ElytraLayerAccessor.getWingsLocation();
                        }
                        yield info.getSkin().elytraTexture();
                    }
                    default -> info.getSkin().texture();
                };
                yield var4_9 = v1;
            }
            case 3 -> {
                try {
                    ResourceLocation var4_10;
                    yield var4_10 = ResourceLocation.parse((String)String.valueOf(pair.getValue()));
                }
                catch (Exception ignored) {
                    ResourceLocation var4_11;
                    yield var4_11 = MissingTextureAtlasSprite.getLocation();
                }
            }
            case 4 -> {
                ResourceLocation var4_12;
                yield var4_12 = this.textures[0] == null ? null : this.textures[0].getLocation();
            }
            case 5 -> {
                ResourceLocation var4_13;
                yield var4_13 = this.textures[1] == null ? null : this.textures[1].getLocation();
            }
            case 6 -> {
                ResourceLocation var4_14;
                yield var4_14 = this.textures[2] == null ? null : this.textures[2].getLocation();
            }
            case 7 -> {
                ResourceLocation var4_15;
                yield var4_15 = this.textures[3] == null ? null : this.textures[3].getLocation();
            }
            case 8 -> {
                try {
                    ResourceLocation var4_16;
                    yield var4_16 = ((FiguraTexture)((Object)pair.getValue())).getLocation();
                }
                catch (Exception ignored) {
                    ResourceLocation var4_17;
                    yield var4_17 = MissingTextureAtlasSprite.getLocation();
                }
            }
        };
    }

    public static enum OverrideType {
        SKIN,
        CAPE,
        ELYTRA,
        RESOURCE((Type)((Object)String.class), "String"),
        PRIMARY,
        SECONDARY,
        SPECULAR,
        NORMAL,
        CUSTOM((Type)((Object)FiguraTexture.class), "Texture");

        @Nullable
        public final Type argumentType;
        @Nullable
        public final String typeName;

        private OverrideType() {
            this.argumentType = null;
            this.typeName = null;
        }

        private OverrideType(Type argumentType, String typeName) {
            this.argumentType = argumentType;
            this.typeName = typeName;
        }
    }
}

